/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/



var STBPluginAnimate = Object.create(STBModule.prototype);

STBPluginAnimate.name = "PluginAnimate";
STBPluginAnimate.initPlugin = function () {

	var animationType = ['fadeInLeftSmall' , 'fadeInRightSmall' , 'fadeInUpSmall' , 'fadeInDownSmall', 'infinite' , 'bounce', 'flash', 'pulse', 'rubberBand', 'shake', 'swing', 'tada', 'wobble', 'bounceIn', 'bounceInDown', 'bounceInLeft', 'bounceInRight', 'bounceInUp', 'bounceOut', 'bounceOutDown', 'bounceOutLeft', 'bounceOutRight', 'bounceOutUp', 'fadeIn', 'fadeInDown', 'fadeInDownBig', 'fadeInLeft', 'fadeInLeftBig', 'fadeInRight', 'fadeInRightBig', 'fadeInUp', 'fadeInUpBig', 'fadeOut', 'fadeOutDown', 'fadeOutDownBig', 'fadeOutLeft', 'fadeOutLeftBig', 'fadeOutRight', 'fadeOutRightBig', 'fadeOutUp', 'fadeOutUpBig', 'flipInX', 'flipInY', 'flipOutX', 'flipOutY', 'lightSpeedIn', 'lightSpeedOut', 'rotateIn', 'rotateInDownLeft', 'rotateInDownRight', 'rotateInUpLeft', 'rotateInUpRight', 'rotateOut', 'rotateOutDownLeft', 'rotateOutDownRight', 'rotateOutUpLeft', 'rotateOutUpRight', 'hinge', 'rollIn', 'rollOut', 'zoomIn', 'zoomInDown', 'zoomInLeft', 'zoomInRight', 'zoomInUp', 'zoomOut', 'zoomOutDown', 'zoomOutLeft', 'zoomOutRight', 'zoomOutUp', 'slideInDown', 'slideInLeft', 'slideInRight', 'slideInUp', 'slideOutDown', 'slideOutLeft', 'slideOutRight', 'slideOutUp'],
		lnt = animationType.length,
		hasPreloader = STBGlobalPreloader.isVisible();

	if (jQuery(".animated:not([data-animate])").length > 0) {


		for (var i = 0; i < lnt; i++) {
			var obj = jQuery("." + animationType[i] + ":not([data-animate])");

			if (obj.length > 0) {

				obj.each(function() {

					var element = jQuery(this);

					if (!STBUtils.isInView(jQuery(this)) || hasPreloader) {
						jQuery(this).attr("data-animate", "animated").removeClass("animated");

						var dataValue = element.attr("data-animate");

						element.attr("data-animate", dataValue + ' ' + animationType[i]).removeClass(animationType[i]).addClass("to-animate");
					} else {
						jQuery(this).attr("data-animate" , "__");
					}

				});
			}

		}


	}

	//add animation for titles
	jQuery(".widget-head:not(.__done_animate), .module-head:not(.__done_animate)").addClass("to-animate").attr("data-animate", "animated-title");

	var dataAnimate = jQuery('[data-animate]:not(.__done_animate)');

	if (dataAnimate.length > 0) {

		dataAnimate.each(function() {
			var element = jQuery(this);

			if (STBGlobalPreloader.isVisible())	{
				element.data("inview-force", true);
			}

			element.bind('inview', function (event, isInView) {
				if (isInView) {
					if (!STBGlobalPreloader.isVisible())	{
						STBPluginAnimate.animate(element);
						element.unbind('inview');						
					}
				}
			});

		});
	}
}

STBPluginAnimate.animateVisible = function() {
	var elements = jQuery(".to-animate");

	if (elements.length > 0){
		elements.each(function() {
			var el = jQuery(this);

			if (STBUtils.isInView(el)) {
				STBPluginAnimate.animate(el);				
			}
		});
	}
}

STBPluginAnimate.animate = function(element) {

	var delay = 0,
		classes = element.attr("class").split(" ");

	if (classes.length > 0) {

		jQuery.each(classes , function(index,value) {
			var val = "";
			if (value.indexOf("delay") != -1){
				val = STBUtils.str_replace(
					"delay-",
					"",
					STBUtils.str_replace(
						"s" , 
						"" , 
						value
					)											
				).trim();
			}

			if (val != "") {
				delay = parseFloat(val) * 1000;
			}
		});
	}

	if (delay != 0) {
		setTimeout(function() {
			element.addClass(element.attr("data-animate")).removeClass("to-animate");
		}, delay);
	} else {
		element.addClass(element.attr("data-animate")).removeClass("to-animate");
	}
}


STBPluginAnimate.runOnLoad = function() {

	STBPluginAnimate.initPlugin();
}

STBPluginAnimate.runOnContentUpdate = function() {
	STBPluginAnimate.initPlugin();
}

STBPluginAnimate.runAfterLoad = function() {

	if (!STBGlobalPreloader.isActive()){
		return null;
	}

	setTimeout(
		function() {
			STBPluginAnimate.animateVisible();
		},
		STBGlobalPreloader.fadeDuration
	);
}

site.registerModule(STBPluginAnimate);